/*
 Shift Register Example
 for TPIC6B595 shift register by Jens C Brynildsen

 This sketch turns reads serial input and uses it to set the pins
 of a TPIC6B595 shift register.

 Hardware:
 * TPIC6B595 shift register attached to pins 7, 8, 11 and 12 of the Arduino,
 as detailed below.
 * LEDs attached to each of the outputs of the shift register

 Based on the example created 23 Mar 2010 by Tom Igoe

 */

//Pin to clear the register
const int clearPin = 7;
//Pin connected to latch pin (ST_CP) of 74HC595
const int latchPin = 8;
//Pin connected to clock pin (SH_CP) of 74HC595
const int clockPin = 12;
////Pin connected to Data in (DS) of 74HC595
const int dataPin = 11;

int counter = 0;
int numLedsInUse = 24;

void setup() {
  //set pins to output because they are addressed in the main loop
  pinMode(clearPin, OUTPUT);
  pinMode(latchPin, OUTPUT);
  pinMode(dataPin, OUTPUT);  
  pinMode(clockPin, OUTPUT);
  Serial.begin(9600);
  Serial.println("*");
  
  // delay a little and then set 
  delay(10);
  // Always start by sentting SRCLR high
  digitalWrite( clearPin, HIGH);
}

void loop() {
  // Display LED's running
  if( counter >= (numLedsInUse-1) ){
    counter = 0;
  } else {
    counter++;
  }
  
  // write to the shift register with the correct bit set high:
  registerWrite(counter, HIGH);
  delay( 10 );
}

// This method sends bits to the shift register:

void registerWrite(int whichPin, int whichState) {
  // the bits you want to send
  byte bitsToSend0 = 0;
  byte bitsToSend1 = 0;
  byte bitsToSend2 = 0;

  // turn off the output so the pins don't light up
  // while you're shifting bits:
  digitalWrite(latchPin, LOW);
  
  // Set bit pattern
  bitWrite(bitsToSend0, whichPin, whichState);
  if( whichPin > 7 ){
    bitWrite(bitsToSend1, whichPin-8, whichState);
  }
  if( whichPin > 15 ){
    bitWrite(bitsToSend2, whichPin-16, whichState);
  }
  
  // shift the bits out for all three registers. Note the opposite order.
  shiftOut(dataPin, clockPin, MSBFIRST, bitsToSend2);
  shiftOut(dataPin, clockPin, MSBFIRST, bitsToSend1);
  shiftOut(dataPin, clockPin, MSBFIRST, bitsToSend0);

  // turn on the output so the LEDs can light up:
  digitalWrite(latchPin, HIGH);

  /*
  // debug output
  Serial.print( counter );
  Serial.print( " - " );
  Serial.print( " bitsToSend0 " );
  Serial.print( bitsToSend0, BIN );
  Serial.print( " bitsToSend1 " );
  Serial.print( bitsToSend1, BIN );
  Serial.print( " bitsToSend2 " );
  Serial.println( bitsToSend2, BIN );
  */
}
