/* Rotary encoder read example */
#define ENC_A 14
#define ENC_B 15
#define ENC_PORT PINC

const int redPin = 3;
const int greenPin = 5;
const int bluePin = 6;

int counter = 255;      //this variable will be changed by encoder input
int rC = counter; // state 0
int gC = counter; // state 1
int bC = counter; // state 2
int state = -1;
boolean buttonIsIn = false;
 
void setup()
{
  /* Setup encoder pins as inputs */
  pinMode(ENC_A, INPUT);
  digitalWrite(ENC_A, HIGH);
  pinMode(ENC_B, INPUT);
  digitalWrite(ENC_B, HIGH);
  Serial.begin (115200);
  Serial.println("Start");
  
  // indicator LEDs
  pinMode(9, OUTPUT);
  pinMode(10, OUTPUT);
  pinMode(11, OUTPUT);
  
  // RGB LED
  pinMode(redPin, OUTPUT);
  pinMode(greenPin, OUTPUT);
  pinMode(bluePin, OUTPUT);
  analogWrite(redPin, rC);
  analogWrite(greenPin, gC);
  analogWrite(bluePin, bC);
  
  // color switch
  digitalWrite(12,HIGH); // pull input 12 HIGH to prevent noise
  pinMode(12, INPUT);
}
 
void loop()
{
  // state handling
  if( !buttonIsIn && digitalRead(12) == HIGH ){
    buttonIsIn = true;
    changeState(); // save current color
    updateControlLeds();
  } else if( buttonIsIn && digitalRead(12) == LOW ){
    buttonIsIn = false;
  }
  
  // encoder handling
  int8_t tmpdata;
  tmpdata = read_encoder();
  if( tmpdata ) {
    counter += tmpdata*5;
    counter = constrain( abs(counter), 0, 255);
    updateValue();
  }
}

void changeState()
{
  Serial.print("counter before state: ");
  Serial.println(counter);
  
  switch( state ){
    case 0: rC = counter; counter = gC; break;
    case 1: gC = counter; counter = bC; break;
    case 2: bC = counter; counter = rC; break;
  }
  
  Serial.print("counter after state: ");
  Serial.println(counter);
  state++;
  if(state == 3){ state = 0; }
}

void debugColor()
{
  Serial.print("r");
  Serial.print(rC);
  Serial.print(" g");
  Serial.print(gC);
  Serial.print(" b");
  Serial.print(bC);
  Serial.print(" state: ");
  Serial.println(state);
}

void updateValue()
{
  Serial.print("counter:");
  Serial.println(counter);
  
  switch( state ){
    case 0: rC = counter; break;
    case 1: gC = counter; break;
    case 2: bC = counter; break;
  }
  
  analogWrite(redPin, rC);
  analogWrite(greenPin, gC);
  analogWrite(bluePin, bC);
  debugColor();
}

void updateControlLeds()
{
  digitalWrite(9,LOW);
  digitalWrite(10,LOW);
  digitalWrite(11,LOW);
  
  switch( state ){
    case 0: digitalWrite(9,HIGH); break;
    case 1: digitalWrite(10,HIGH); break;
    case 2: digitalWrite(11,HIGH); break;
  }
  
  delay(20);
}
 
/* returns change in encoder state (-1,0,1) */
int8_t read_encoder()
{
  static int8_t enc_states[] = {0,-1,1,0,1,0,0,-1,-1,0,0,1,0,1,-1,0};
  static uint8_t old_AB = 0;
  /**/
  old_AB <<= 2;                   //remember previous state
  old_AB |= ( ENC_PORT & 0x03 );  //add current state
  return ( enc_states[( old_AB & 0x0f )]);
}
